unit GraphClipboardTools;

// -----------------------------------------------------------------------
//      BitMap 
//    (   canvas)  Clipboard
// (    UNIT : Clipbrd )
// -----------------------------------------------------------------------

interface
uses Windows, Classes, Graphics, Dialogs, Clipbrd;

//    BitMap  Clipboard
function CopyBitMapToClipboard(RqBitMap : TBitMap) : boolean;

//   Clipboard  BitMap,  BitMap,   
// Canvas  ,     BitMap.
function PasteBitMapFromClipboard(RqX, RqY : integer;
                                  RqBitMap : TBitMap) : boolean;

//  :
// CopyBitMapToClipboard (Image1.Picture.Bitmap);
// PasteBitMapFromClipboard (0,0, Image1.Picture.Bitmap);

// =======================================================================
// =======================================================================
implementation
// =======================================================================
// =======================================================================
//    BitMap  Clipboard
// 28.05.2014 ()
function CopyBitMapToClipboard(RqBitMap : TBitMap) : boolean;
begin
  Result := False;
  try
    Clipboard.Assign(RqBitMap);
    Result := True;
  except
    MessageDlg('    Clipboard',
                mtError, [mbOk], 0);
  end;
end;
// -----------------------------------------------------------------------
//   Clipboard  BitMap,  BitMap,   
// Canvas  ,     BitMap.
// 28.05.2014 ()
function PasteBitMapFromClipboard(RqX, RqY : integer;
                                  RqBitMap : TBitMap) : boolean;
var WBitmap   : TBitmap;    //  Bitmap
    SCopyMode : TCopyMode;  //    Canvas.CopyMode
begin
  Result := False;
  //   Clipboard  Windows BitMap
  if Clipboard.HasFormat(CF_BITMAP) then
  begin
    WBitmap := TBitmap.Create;
    try
      //  Clipboard  BitMap.
      //   WBitmap   Assign
      WBitmap.Assign(Clipboard);
      //   Canvas.CopyMode
      SCopyMode := RqBitMap.Canvas.CopyMode;
      //  BitMap  RqBitMap
      RqBitMap.Canvas.CopyMode := cmSrcCopy;
      RqBitMap.Canvas.Draw(RqX, RqY, WBitmap);
      //   Canvas.CopyMode
      RqBitMap.Canvas.CopyMode := SCopyMode;
      Result := True;
    finally
      WBitmap.Free;
    end;
  end;
end;


end.
